/*
 * Copyright (c) 2015,2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution and use  in source  and binary  forms,  with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 *
 *                                      Anthony Mallet on Wed Mar 11 2015
 */
#include "acheader.h"

#include <avr/pgmspace.h>

#include <string.h>

#include "common/tk3-mikrokopter.h"
#include "mkfl.h"


/* --- tk3_motor_init ------------------------------------------------------ */

uint8_t
tk3_motor_init(uint32_t timeout)
{
  struct tk3_iorecv *msg;
  tk3_time date, deadline, q;
  uint32_t status;
  uint8_t count;

  /* send id request to motors, until timeout */
  status = 0;
  q = tk3_clock_gettime();
  deadline = q + timeout;
  while(1) {
    date = tk3_clock_gettime();
    if ((deadline - date) & 0x80000000U) break;

    /* update led status */
    tk3_led_update(date);

    /* send request to missing motors every 500ms */
    if ((q - date) & 0x80000000U) {
      tk3_log(TK3_TWI, PSTR("?"));
      tk3_send();
      q += 500000;
    }

    /* process received messages */
    while ((msg = tk3_recv())) {
      uint8_t cmd = msg->data[0];

      switch(cmd) {
        case '?': /* id */
          if (msg->len < 2) break;
          if (msg->data[1] < 1 || msg->data[1] > settings.motors) break;
          if (strncmp_P((char *)&msg->data[2],
                        PSTR("mkbl"), sizeof("mkbl")-1))
            break;
          status |= (uint32_t)1 << (msg->data[1]-1);
          break;
      }
    }

    if (status == (1 << settings.motors) -1) break;
  }

  /* count replies */
  for(count = 0; status; status >>= 1)
    if (status & 1) count++;

  return count;
}
