/*
 * Copyright (c) 2015,2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution and use  in source  and binary  forms,  with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 *
 *                                      Anthony Mallet on Fri Feb 13 2015
 */
#ifndef H_MKFL
#define H_MKFL

#include <stdint.h>

/* sensor */
struct tk3_sensors {
  uint16_t battery;
  int16_t acc_x, acc_y, acc_z;
  int16_t gyro_roll, gyro_pitch, gyro_yaw;
  uint16_t barometer;
};
extern struct tk3_sensors tk3_sensors;

void		tk3_sensor_init(void);
void		tk3_sensor_gyrocal(tk3_time d, enum tk3_channel r);
void		tk3_sensor_acccal(tk3_time d, enum tk3_channel r);


/* motors */
uint8_t		tk3_motor_init(uint32_t timeout);


/* leds */
enum __attribute__((__packed__)) tk3_led_id {
  TK3_LED_GRN1,
  TK3_LED_RED2,
  TK3_LED_GRN3,
  TK3_LED_GRN4
};

void	tk3_led_init(void);
void	tk3_led(enum tk3_led_id id, uint8_t duty);
void	tk3_led_update(tk3_time date);


/* settings */
#define TK3SET_VERSION		"version"
#define TK3SET_ROBOT		"robot-id"
#define TK3SET_MOTORS		"motors"
#define TK3SET_GYRO_YOFF	"gyro-yoff"
#define TK3SET_GYRO_YSEN	"gyro-ysen"
#define TK3SET_GYRO_POFF	"gyro-poff"
#define TK3SET_GYRO_PSEN	"gyro-psen"
#define TK3SET_GYRO_ROFF	"gyro-roff"
#define TK3SET_GYRO_RSEN	"gyro-rsen"
#define TK3SET_ACC_XOFF		"acc-xoff"
#define TK3SET_ACC_XSEN		"acc-xsen"
#define TK3SET_ACC_YOFF		"acc-yoff"
#define TK3SET_ACC_YSEN		"acc-ysen"
#define TK3SET_ACC_ZOFF		"acc-zoff"
#define TK3SET_ACC_ZSEN		"acc-zsen"

extern struct tk3_settings {
  uint8_t version;
  uint8_t *version_addr;
  uint8_t robot_id;
  uint8_t motors;
  uint32_t uart;

  int16_t gyro_roff, gyro_poff, gyro_yoff;
  uint16_t gyro_rsen, gyro_psen, gyro_ysen;
  uint8_t *gyro_roff_addr, *gyro_poff_addr, *gyro_yoff_addr;
  uint8_t *gyro_rsen_addr, *gyro_psen_addr, *gyro_ysen_addr;

  int16_t acc_xoff, acc_yoff, acc_zoff;
  uint16_t acc_xsen, acc_ysen, acc_zsen;
  uint8_t *acc_xoff_addr, *acc_yoff_addr, *acc_zoff_addr;
  uint8_t *acc_xsen_addr, *acc_ysen_addr, *acc_zsen_addr;
} settings;

void	tk3_load_settings(void);


/* logging */
void	tk3_logdef_imu(enum tk3_channel channel, uint32_t period,
                tk3_time date);
void	tk3_log_imu(tk3_time date);

void	tk3_logdef_motor(enum tk3_channel channel, bool log);
void	tk3_log_motor(const uint8_t *msg, uint8_t len);

void	tk3_logdef_battery(enum tk3_channel channel, uint32_t period,
                tk3_time date);
void	tk3_log_battery(tk3_time date);


#endif /* H_MKFL */
