/*
 * Copyright (c) 2015,2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution and use  in source  and binary  forms,  with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 *
 *                                      Anthony Mallet on Wed Mar 11 2015
 */
#include "acheader.h"

#include "common/tk3-mikrokopter.h"
#include "mkfl.h"

static uint8_t dcycle[4], maxled;


/* --- tk3_led_init -------------------------------------------------------- */

void
tk3_led_init(void)
{
  uint8_t i;

  for(i = 0; i < sizeof(dcycle)/sizeof(dcycle[0]); i++)
    dcycle[i] = 0;

  /* led 1/2 */
  DDRB |= (1 << DDB0) | (1 << DDB1);
  PORTB &= ~((1 << PB0) | (1 << PB1));

  /* led 3/4 for fc > 2.5 */
  if (settings.version >= 25) {
    maxled = TK3_LED_GRN4;
    DDRC |= (1 << DDC2) | (1 << DDC3);
    PORTC &= ~((1 << PC2) | (1 << PC3));
  } else
    maxled = TK3_LED_RED2;
}


/* --- tk3_led ------------------------------------------------------------- */

void
tk3_led(enum tk3_led_id id, uint8_t duty)
{
  if (id == TK3_LED_GRN1 && settings.version < 25) {
    /* green led on FL 2.2 is inverted */
    duty = 255 - duty;
  }
    
  dcycle[id] = duty;
  tk3_led_update(tk3_clock_gettime());
}


/* --- tk3_led_update ------------------------------------------------------ */

void
tk3_led_update(tk3_time date)
{
  uint8_t frac = (date & 0xfffff /* ~1s */) >> 12;
  uint8_t i;

  for(i = 0; i <= maxled; i++) {
    if (!dcycle[i] || frac > dcycle[i]) {
      switch(i) {
        case TK3_LED_GRN1: PORTB &= ~(1 << PB1); break;
        case TK3_LED_RED2: PORTB &= ~(1 << PB0); break;
        case TK3_LED_GRN3: PORTC &= ~(1 << PC2); break;
        case TK3_LED_GRN4: PORTC &= ~(1 << PC3); break;
      }
    } else {
      switch(i) {
        case TK3_LED_GRN1: PORTB |= (1 << PB1); break;
        case TK3_LED_RED2: PORTB |= (1 << PB0); break;
        case TK3_LED_GRN3: PORTC |= (1 << PC2); break;
        case TK3_LED_GRN4: PORTC |= (1 << PC3); break;
      }
    }
  }
}
