/*
 * Copyright (c) 2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution and use  in source  and binary  forms,  with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 *
 *                                      Anthony Mallet on Thu Feb  9 2017
 */
#include "acheader.h"

#include "common/tk3-mikrokopter.h"
#include "flymu.h"

static uint8_t dcycle[3] = {0};


/* --- fmu_led_init -------------------------------------------------------- */

void
fmu_led_init(void)
{
  /* portc 0/1/2 out, leds off */
  DDRC |= (1 << DDC0) | (1 << DDC1) | (1 << DDC2);
  PORTC |= (1 << PC0) | (1 << PC1) | (1 << PC2);
}


/* --- tk3_led ------------------------------------------------------------- */

void
fmu_led(enum fmu_led_id id, uint8_t duty)
{
  /* leds are active low */
  dcycle[id] = duty;
}


/* --- tk3_led_update ------------------------------------------------------ */

void
fmu_led_update(tk3_time date)
{
  uint8_t frac = (date & 0xfffff /* ~1s */) >> 12;
  uint8_t i;

  for(i = 0; i < 3; i++) {
    if (!dcycle[i] || frac > dcycle[i]) {
      switch(i) {
        case FMULED_IDLE:	PORTC |= (1 << PC0); break;
        case FMULED_PKTLOSS:	PORTC |= (1 << PC1); break;
        case FMULED_ERR:	PORTC |= (1 << PC2); break;
      }
    } else {
      switch(i) {
        case FMULED_IDLE:	PORTC &= ~(1 << PC0); break;
        case FMULED_PKTLOSS:	PORTC &= ~(1 << PC1); break;
        case FMULED_ERR:	PORTC &= ~(1 << PC2); break;
      }
    }
  }
}
