/*
 * Copyright (c) 2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *					Anthony Mallet on Tue Feb  7 2017
 */
#ifndef H_FLYMU
#define H_FLYMU

#include <stdint.h>

/* i/o */
void	fmu_domsg(struct tk3_iorecv *msg);


/* sensors */
struct fmu_sensors {
  uint16_t battery;
  int16_t acc_x, acc_y, acc_z;
  int16_t gyro_roll, gyro_pitch, gyro_yaw;
  uint16_t barometer;
};
extern volatile struct fmu_sensors fmu_sensors;

uint8_t		fmu_sensor_init(void);


/* motors */
uint8_t		fmu_motor_init(uint32_t timeout);


/* leds */
enum __attribute__((__packed__)) fmu_led_id {
  FMULED_IDLE,
  FMULED_PKTLOSS,
  FMULED_ERR
};

void	fmu_led_init(void);
void	fmu_led(enum fmu_led_id id, uint8_t duty);
void	fmu_led_update(tk3_time date);


/* settings */
#define TK3SET_VERSION		"version"
#define TK3SET_ROBOT		"robot-id"
#define TK3SET_MOTORS		"motors"

extern struct fmu_settings {
  uint8_t version;
  uint8_t *version_addr;
  uint8_t robot_id;
  uint8_t motors;
  uint32_t uart;
} settings;

void	fmu_load_settings(void);


/* logging */
void fmu_logdef_imu(enum tk3_channel channel, uint32_t period, tk3_time date);
void fmu_log_imu(tk3_time date);
void fmu_logdef_motor(enum tk3_channel channel, bool log);
void fmu_log_motor(const uint8_t *msg, uint8_t len);
void fmu_logdef_battery(enum tk3_channel channel, uint32_t period,
             tk3_time date);
void fmu_log_battery(tk3_time date);

#endif /* H_FLYMU */
