/*
 * Copyright (c) 2014-2015,2017,2019 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *					Anthony Mallet on Tue Sep 23 2014
 */
#ifndef H_TK3_MIKROKOPTER
#define H_TK3_MIKROKOPTER

#include <avr/eeprom.h>

#include <stdint.h>
#include <stdbool.h>

/* clock */
typedef uint32_t tk3_time;

int		tk3_clock_init(int8_t clk_adj, uint8_t *adj_addr);
tk3_time	tk3_clock_gettime(void);
void		tk3_clock_delay(tk3_time deadline);
uint8_t		tk3_clock_reftick(tk3_time time, tk3_time ref);
void		tk3_clock_callback(tk3_time time, void (*callback)(void));


/* settings */
#define TK3SET_MAGIC	"tk3"
#define TK3SET_UART	"uart"
#define TK3SET_CLKADJ	"clock-adj"

extern const uint8_t *tk3_settings_start;
extern const uint8_t *tk3_settings_end;

int		tk3_settings_init(void);
int		tk3_settings_next(char *key, size_t len, int32_t *value);
uint8_t *	tk3_settings_addr(const char *key);
void		tk3_settings_update(uint8_t *addr, int32_t value);


/* io */
#include "iodefs.h"

#define TK3TWI_BASEADDR		0x10

#define TK3_REG(x, n, y)	(x ## n ## y)
#define TK3_TWI_REG(x, n)	TK3_REG(TW, x, n)
#define TK3_TW(x)		TK3_TWI_REG(x, TK3_TWI_BUS)

#define TWBR_	TWBR

enum __attribute__((__packed__)) tk3_channel {
  TK3_UART0,
  TK3_UART1,
  TK3_TWI,

  TK3_CHANNEL_MAX
};

struct tk3_iorecv {
  struct {
    unsigned start:1;
    unsigned escape:1;
    const unsigned channel:2;
  } state;

  uint8_t len;
  uint8_t data[32];
};

uint8_t			tk3_uart_init(uint8_t unit, uint32_t baud);
void			tk3_twi_init(uint8_t addr);
struct tk3_iorecv *	tk3_recv(void);
void			tk3_log(enum tk3_channel c, const char *fmt, ...);
void			tk3_log_buffer(enum tk3_channel channel,
                                const uint8_t *buffer, uint8_t len);
void			tk3_send(void);

extern uint8_t		tk3_comm_errs;
extern uint8_t		tk3_comm_warns;

#endif /* H_TK3_MIKROKOPTER */
