/*
 * Copyright (c) 2017 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Mon Jan  2 2017
 */
#ifndef H_TK3_IOM328PB
#define H_TK3_IOM328PB

#ifndef SIGRD
#define SIGRD 5
#endif

#ifdef __AVR_ATmega328PB__
# error "__AVR_ATmega328PB__ already defined"
#endif
#define __AVR_ATmega328PB__	1

/* ATmega328pb has a few more peripherals compared to 328p */

/* Port E Input Pins Address */
#define PINE		_SFR_IO8(0x0c)
#define PINE0 0
#define PINE1 1
#define PINE2 2
#define PINE3 3

/* Port E Data Direction Register */
#define DDRE		_SFR_IO8(0x0d)
#define DDE0 0
#define DDE1 1
#define DDE2 2
#define DDE3 3

/* Port E Data Register */
#define PORTE		_SFR_IO8(0x0e)
#define PORTE0 0
#define PORTE1 1
#define PORTE2 2
#define PORTE3 3

#define UCSR1A	_SFR_MEM8(0xc8)
#define MPCM1	0
#define U2X1	1
#define UPE1	2
#define DOR1	3
#define FE1	4
#define UDRE1	5
#define TXC1	6
#define RXC1	7

#define UCSR1B	_SFR_MEM8(0xc9)
#define TXB81	0
#define RXB81	1
#define UCSZ12	2
#define TXEN1	3
#define RXEN1	4
#define UDRIE1	5
#define TXCIE1	6
#define RXCIE1	7

#define UCSR1C	_SFR_MEM8(0xca)
#define UCPOL1	0
#define UCSZ10	1
#define UCPHA1	1
#define UCSZ11	2
#define UDORD1	2
#define USBS1	3
#define UPM10	4
#define UPM11	5
#define UMSEL10	6
#define UMSEL11	7

#define UBRR1	_SFR_MEM16(0xcc)

#define UDR1	_SFR_MEM8(0xce)

#define TWBR_1	_SFR_MEM8(0xb8 + 0x20)
#define TWSR1	_SFR_MEM8(0xb9 + 0x20)
#define TWAR1	_SFR_MEM8(0xba + 0x20)
#define TWDR1	_SFR_MEM8(0xbb + 0x20)
#define TWCR1	_SFR_MEM8(0xbc + 0x20)

/* Pin Change Interrupt Control Register */
#define PCIE3 3

/* Pin Change Mask Register 3 */
#define PCMSK3		_SFR_MEM8(0x73)
#define PCINT24 0
#define PCINT25 1
#define PCINT26 2
#define PCINT27 3

/* Interrupt Vectors */
#define PCINT3_vect_num	   27
#define PCINT3_vect	   _VECTOR(27)  /* Pin Change Interrupt Request 3 */

#define USART1_RX_vect_num 28
#define USART1_RX_vect     _VECTOR(28)  /* USART1 Rx Complete */

#define TWI1_vect_num      40
#define TWI1_vect          _VECTOR(40)  /* Two-wire1 Serial Interface */

#endif /* H_TK3_IOM328PB */
