/*
 * Copyright (c) 2014, 2017, 2019-2020, 2025 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Fri May 23 2014
 */
#ifndef H_FLASH
#define H_FLASH

#include <stdint.h>
#include <libelf.h>

#define TK3_MAGIC	"tk3"

enum bltype { MKBL_MKBL, MKBL_FLYMU, STM32BL };
enum ldtype { LD_DATA, LD_SETTINGS };
enum settype { SET_KEEP, SET_RESET, SET_MERGE };

int		open_tty(const char *input, unsigned int baud,
                        unsigned int parity, const char **serial);
void		write_serial(int fd, const void *buf, size_t count);
ssize_t		read_serial(int fd, void *buf, size_t count, int timeout);

const char *	usb_serial_to_tty(const char *serial);
const char *	usb_tty_to_serial(const char *node);
int		usb_set_serial(const char *old, const char *new);

Elf *		elf_init(const char *input, uint16_t machine);
char *		elf_loadable_data(Elf *elf, uintptr_t *paddr, size_t *size,
                        enum ldtype kind);

int		probe_bootloader(const char *port, int baud,
                        const char **serial, enum bltype *bltype);

uint16_t	mkbl_crc16(char *buffer, size_t len);

int		mkbl_flash(const char *exe, int fd, const char *serial,
                        enum bltype bltype, enum settype init_p);
int		mkbl_params(int fd, const char *serial, enum bltype bltype,
                        char **argv);
int		mkbl_reset(int fd);

int		stm32_flash(const char *exe, int fd, const char *serial,
                        enum settype init_p);
int		stm32_params(int fd, const char *serial, char **argv);
int		stm32_reset(int fd);

void		print_settings(const char *serial, const char *data);
int		set_char_settings(char *dst, const char *key,
                        const char *value);
int		set_settings(char *dst, const char *key, int32_t value);
int		merge_settings(char *dst, const char *src, int drop);
int		update_serial(char **input, char **argv);

#endif /* H_FLASH */
