/*
 *	This file is part of qpOASES.
 *
 *	qpOASES -- An Implementation of the Online Active Set Strategy.
 *	Copyright (C) 2007-2017 by Hans Joachim Ferreau, Andreas Potschka,
 *	Christian Kirches et al. All rights reserved.
 *
 *	qpOASES is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	qpOASES is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with qpOASES; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


/**
 *	\author Andrea Zanelli
 *	\version 3.2
 *	\date 2022
 *
 *	QP data generated by a Python script for testing purposes.
 */


USING_NAMESPACE_QPOASES

#define NV {{NV}}
#define NC {{NC}}

const real_t Inf = INFTY;

sparse_int_t H_ri[] = {
    {% for d in H_ri %}
    {{ d }},
    {%- endfor %}
};

sparse_int_t H_cp[] = { 
    {% for d in H_cp %}
    {{ d }},
    {%- endfor %}
};

real_t H_val[] = {
    {% for d in H_val %}
    {{ d }},
    {%- endfor %}
};

sparse_int_t A_ri[] = {
    {% for d in A_ri %}
    {{ d }},
    {%- endfor %}
};

sparse_int_t A_cp[] = {
    {% for d in A_cp %}
    {{ d }},
    {%- endfor %}
};

real_t A_val[] = {
    {% for d in A_val %}
    {{ d }},
    {%- endfor %}
};

real_t g[] = {
    {% for d in g %}
    {{ d[0] }},
    {%- endfor %}
};

real_t lb[] = {
    {% for d in lb %}
    {{ d[0] }},
    {%- endfor %}
};

real_t ub[] = {
    {% for d in ub %}
    {{ d[0] }},
    {%- endfor %}
};

real_t lbA[] = {
    {% for d in lbA %}
    {{ d[0] }},
    {%- endfor %}
};

real_t ubA[] = {
    {% for d in ubA %}
    {{ d[0] }},
    {%- endfor %}
    };

long H_nnz = {{ H_nnz }}; 
long A_nnz = {{ A_nnz }};
