//
// Copyright (c) 2014 CNRS
// Authors: Florent Lamiraux
//
//
// This file is part of hpp_tutorial
// hpp_tutorial is free software: you can redistribute it
// and/or modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation, either version
// 3 of the License, or (at your option) any later version.
//
// hpp_tutorial is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Lesser Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// hpp_tutorial  If not, see
// <http://www.gnu.org/licenses/>.

/// \mainpage Tutorials
/// \anchor hpp_tutorial_documentation
///
/// \par Introduction
///
/// These tutorials explain how to define and solve a path planning
/// problem, how to display the resulting paths in gepetto-viewer, and
/// how to implement a new path planning algorithm.
///
/// \par Setting up your environment
///
/// Before starting, make sure that
/// \li \c bash is you default shell script language,
/// \li the line \code source $DEVEL_DIR/config.sh \endcode is in your .bashrc
/// file, where \c DEVEL_DIR is the environment variable defined in the
/// <a href="https://github.com/humanoid-path-planner/hpp-doc/tree/ros-hydro">
/// installation instructions</a>.
///
/// \par Tutorials
///
/// \li \link hpp_tutorial_tutorial_1 Tutorial 1 (python)\endlink: how to
///     define and solve a path planning problem using CORBA.
/// \li \link hpp_tutorial_tutorial_1_cpp Tutorial 1 (C++)\endlink how to
///     define and solve the same path planning problem without middleware.
/// \li \link hpp_tutorial_tutorial_2 Tutorial 2 - plugin\endlink : how to
/// implement
///     a new path planning algorithm in C++.
/// \li \link hpp_tutorial_tutorial_3 Tutorial 3 - manipulation \endlink : how
/// to define and solve a manipulation planning problem. \li \link
/// hpp_tutorial_tutorial_4 Tutorial 4 - inverse kinematics \endlink: how to
/// plan
///     end-effector trajectoties
