// Copyright (c) 2014, LAAS-CNRS
// Authors: Joseph Mirabel (joseph.mirabel@laas.fr)
//
// This file is part of hpp-statistics.
// hpp-statistics is free software: you can redistribute it
// and/or modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation, either version
// 3 of the License, or (at your option) any later version.
//
// hpp-statistics is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Lesser Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// hpp-statistics. If not, see <http://www.gnu.org/licenses/>.

namespace hpp {
namespace statistics {
/**

  \mainpage

  This package provides basic tools for statistics. It contains:
  \li DiscreteDistribution a templated class containing pairs of object and
      their corresponding weights. A weight define the probability of an
      object to be randomly picked.
  \li Statistics a templated class to do histograms. It stores Bin and count
      the number of times they are added.
  \li SuccessStatistics enhances Statistics<SuccessBin>.

 **/
}
}  // namespace hpp
