//
// Copyright (c) 2018 - 2023 CNRS
// Authors: Joseph Mirabel, Florent Lamiraux
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:

// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.

// 2. Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following
// disclaimer in the documentation and/or other materials provided
// with the distribution.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
// FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.

#include <boost/python.hpp>
#include <hpp/core/fwd.hh>
#include <hpp/util/debug.hh>
#include <pyhpp/core/fwd.hh>
#include <pyhpp/stl-pair.hh>
#include <pyhpp/util.hh>

BOOST_PYTHON_MODULE(bindings) {
  INIT_PYHPP_MODULE;

  boost::python::import("pyhpp.constraints");

  pyhpp::stl_pair<hpp::core::value_type, hpp::core::value_type>("interval");

  pyhpp::core::exposeParameter();
  pyhpp::core::exposeProblem();
  pyhpp::core::exposeProblemSolver();

  pyhpp::core::exposeConfigValidation();
  pyhpp::core::exposeConfigurationShooter();
  pyhpp::core::exposeConstraint();
  pyhpp::core::exposeReports();
  pyhpp::core::exposeSteeringMethod();
  pyhpp::core::exposeNode();
  pyhpp::core::exposeDistance();
  pyhpp::core::exposeConnectedComponent();
  pyhpp::core::exposeRoadmap();
  pyhpp::core::exposeProblemTarget();

  // Expose main abstract classes
  pyhpp::core::exposePath();
  pyhpp::core::exposePathOptimizer();
  pyhpp::core::exposePathProjector();
  pyhpp::core::exposePathValidation();

  pyhpp::core::exposePathPlanner();

  boost::python::import("pyhpp.core.path");
  boost::python::import("pyhpp.core.path_optimization");

  boost::python::import("pyhpp.core.problem_target");

  // Bind method that sets verbosity level
  boost::python::def("setVerbosityLevel", &::hpp::debug::setVerbosityLevel);
  boost::python::def("getVerbosityLevel", &::hpp::debug::getVerbosityLevel);
}
