# hpp-python package

Provide Python bindings of the HPP software. These bindings differ from the one provided by
`hpp-corbaserver`. They are native bindings that do not use a middleware.
The bindings are generated by `boost::python`.

### Compilation

Installation follows the standard CMake procedure:
```sh
git clone --recursive ...
mkdir hpp-python/build
cd hpp-python/build
cmake -DCMAKE_INSTALL_PREFIX=... -DCMAKE_BUILD_TYPE=Release ..
make
make test
make install
```

### Generate documentation

Script `doc/configure.py` is used to generate documentation of Python objects from C++ objects.
It reads the XML documentation generated by doxygen so the dependencies must provide such
files. To make it work, do:
- Add `GENERATE_XML=YES` into `doc/Doxyfile.extra.in` of all the dependency of this project.
- Install the generated documentation by adding the following lines to `CMakeLists.txt`:
```cmake
IF(_INSTALL_DOC)
  INSTALL(DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/doc/doxygen-xml
    DESTINATION ${CMAKE_INSTALL_DOCDIR})
ENDIF()
```

File `doc/configure.py` contains a short documentation of how to document the bindings.

### TODO

- Use doxygen to generate XML documentation of the headers included by a file.
  Then use the generated XML doc to update the documentation of the files in `src/pyhpp`.
  Doxygen configuration variables `INCLUDE_PATH` and `SEARCH_INCLUDES` might be helpful.
