# Copyright (c) 2015 CNRS Authors: Joseph Mirabel
#
# This file is part of hpp-plot hpp-plot is free software: you can redistribute
# it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License,
# or (at your option) any later version.
#
# hpp-plot is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Lesser Public License for more
# details.  You should have received a copy of the GNU Lesser General Public
# License along with hpp-plot  If not, see <http://www.gnu.org/licenses/>.

# * Try to find QGV library Once done this will define
#
# QGV_FOUND - system has QGV installed QGV_INCLUDE_DIR QGV_LIBRARY
#

if(QGV_LIBRARY)
  # in cache already
  set(QGV_FIND_QUIETLY TRUE)
endif(QGV_LIBRARY)

# use pkg-config to get the directories and then use these values in the
# FIND_PATH() and FIND_LIBRARY() calls if( NOT WIN32 ) find_package(PkgConfig)
#
# pkg_check_modules(QGV_PKG qgv) endif( NOT WIN32 )

find_library(
  QGV_LIBRARY
  NAMES QGVCore libQGVCore
  PATHS /usr/lib /usr/local/lib
  HINTS ${QGV_PKG_LIBRARY_DIRS} # Generated by pkg-config
)
if(NOT (QGV_LIBRARY))
  message(STATUS "Could not find libQGVCore.")
  set(QGV_FOUND FALSE)
else()
  set(QGV_FOUND TRUE)
endif()

find_path(
  QGV_INCLUDE_DIR
  NAMES QGVCore.h
  PATHS /usr/include/qgv /usr/local/include/qgv
  HINTS ${QGV_PKG_INCLUDE_DIR} # Generated by pkg-config
)
if(NOT (QGV_INCLUDE_DIR))
  message(STATUS "Could not find QGV headers.")
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(QGV DEFAULT_MSG QGV_LIBRARY)

# show the POPPLER_(XPDF/QT4)_INCLUDE_DIR and POPPLER_LIBRARIES variables only
# in the advanced view
mark_as_advanced(QGV_INCLUDE_DIR QGV_LIBRARY)
