#
# Copyright (c) 2014 CNRS-LAAS
# Author: Florent Lamiraux
#

COAL_REPO=https://github.com/coal-library
LAAS_REPO=https://github.com/laas
HPP_REPO=https://github.com/humanoid-path-planner
SOT_REPO=https://github.com/stack-of-tasks
GEPETTO_REPO=https://github.com/Gepetto
LOCO3D_REPO=https://github.com/loco-3d
SIMPLE_ROBOTICS_REPO=https://github.com/Simple-Robotics
JRL_REPO=https://github.com/jrl-umi3218

SRC_DIR=${DEVEL_HPP_DIR}/src
ifndef INSTALL_HPP_DIR
INSTALL_HPP_DIR=${DEVEL_HPP_DIR}/install
endif

BUILD_TYPE?=Release
BUILD_TESTING?=ON
ifeq (${BUILD_TYPE},Debug)
  BUILD_FOLDER=build
else
  BUILD_FOLDER=build-rel
  BUILD_TESTING=OFF
endif

WGET=wget --quiet
UNZIP=unzip -qq
TAR=tar
GIT_QUIET=--quiet
# Qt version should be either 4 or 5
QT_VERSION=5
INSTALL_DOCUMENTATION=OFF
BUILD_JOBS=4

##################################
# {{{ Dependencies

jrl-cmakemodules_branch=master
jrl-cmakemodules_repository=${JRL_REPO}

coal_branch=devel
coal_repository=${COAL_REPO}
coal_extra_flags= -DCOAL_HAS_QHULL=ON -DCOAL_BACKWARD_COMPATIBILITY_WITH_HPP_FCL=ON -DINSTALL_DOCUMENTATION=OFF -DCOAL_DISABLE_HPP_FCL_WARNINGS=ON

eigenpy_branch=devel
eigenpy_repository=${SOT_REPO}

pinocchio_branch=devel
pinocchio_repository=${SOT_REPO}
pinocchio_extra_flags= -DBUILD_UNIT_TESTS=OFF -DBUILD_WITH_COLLISION_SUPPORT=ON -DINSTALL_DOCUMENTATION=OFF -DCOAL_DISABLE_HPP_FCL_WARNINGS=ON
pinocchio_jobs=2

# }}}
##################################
# {{{ Packages supporting HPP_VERSION

# Either a version tag (e.g. v4.3.0), stable or devel
HPP_VERSION=devel
HPP_EXTRA_FLAGS= -DBUILD_TESTING=${BUILD_TESTING} -DAUTO_UNINSTALL=OFF

hpp-template-corba_branch=${HPP_VERSION}
hpp-template-corba_repository=${HPP_REPO}

hpp-util_branch=${HPP_VERSION}
hpp-util_repository=${HPP_REPO}
hpp-util_extra_flags=${HPP_EXTRA_FLAGS}

hpp-statistics_branch=${HPP_VERSION}
hpp-statistics_repository=${HPP_REPO}
hpp-statistics_extra_flags=${HPP_EXTRA_FLAGS}

hpp-pinocchio_branch=${HPP_VERSION}
hpp-pinocchio_repository=${HPP_REPO}
hpp-pinocchio_extra_flags=${HPP_EXTRA_FLAGS}

hpp-constraints_branch=${HPP_VERSION}
hpp-constraints_repository=${HPP_REPO}
hpp-constraints_extra_flags=${HPP_EXTRA_FLAGS} -DUSE_QPOASES=OFF

hpp-core_branch=${HPP_VERSION}
hpp-core_repository=${HPP_REPO}
hpp-core_extra_flags=${HPP_EXTRA_FLAGS}

hpp-corbaserver_branch=${HPP_VERSION}
hpp-corbaserver_repository=${HPP_REPO}
hpp-corbaserver_jobs=1

hpp-python_branch=${HPP_VERSION}
hpp-python_repository=${HPP_REPO}
hpp-python_extra_flags=${HPP_EXTRA_FLAGS}

hpp-doc_branch=${HPP_VERSION}
hpp-doc_repository=${HPP_REPO}

hpp-manipulation_branch=${HPP_VERSION}
hpp-manipulation_repository=${HPP_REPO}

hpp-manipulation-urdf_branch=${HPP_VERSION}
hpp-manipulation-urdf_repository=${HPP_REPO}

hpp-manipulation-corba_branch=${HPP_VERSION}
hpp-manipulation-corba_repository=${HPP_REPO}
hpp-manipulation-corba_extra_flags=${HPP_EXTRA_FLAGS}
hpp-manipulation-corba_jobs=1

hpp_tutorial_branch=${HPP_VERSION}
hpp_tutorial_repository=${HPP_REPO}
hpp_tutorial_extra_flags=${HPP_EXTRA_FLAGS}

hpp-practicals_branch=${HPP_VERSION}
hpp-practicals_repository=${HPP_REPO}
hpp-practicals_extra_flags=${HPP_EXTRA_FLAGS}

hpp-gepetto-viewer_branch=${HPP_VERSION}
hpp-gepetto-viewer_repository=${HPP_REPO}
hpp-gepetto-viewer_extra_flags= -DINSTALL_DOCUMENTATION=OFF

hpp-plot_branch=${HPP_VERSION}
hpp-plot_repository=${HPP_REPO}
hpp-plot_extra_flags= -DINSTALL_DOCUMENTATION=OFF

hpp-gui_branch=${HPP_VERSION}
hpp-gui_repository=${HPP_REPO}
hpp-gui_extra_flags=${HPP_EXTRA_FLAGS} -DINSTALL_DOCUMENTATION=OFF

# }}}
##################################
# {{{ Robot specific package + test packages

proxsuite_branch = devel
proxsuite_repository=${SIMPLE_ROBOTICS_REPO}
proxsuite_extra_flags= -DBUILD_WITH_VECTORIZATION_SUPPORT=OFF -DBUILD_TESTING=OFF

example-robot-data_branch=devel
example-robot-data_repository=${GEPETTO_REPO}

hpp_benchmark_branch=devel
hpp_benchmark_repository=${HPP_REPO}

hpp-environments_branch=${HPP_VERSION}
hpp-environments_repository=${HPP_REPO}

hpp-universal-robot_branch=${HPP_VERSION}
hpp-universal-robot_repository=${HPP_REPO}

hpp-baxter_branch=${HPP_VERSION}
hpp-baxter_repository=${HPP_REPO}

hpp_romeo_branch=${HPP_VERSION}
hpp_romeo_repository=${HPP_REPO}

# }}}
##################################
# {{{ Packages for rbprm

hpp-affordance_branch=${HPP_VERSION}
hpp-affordance_repository=${HPP_REPO}
hpp-affordance_extra_flags=${HPP_EXTRA_FLAGS}

hpp-affordance-corba_branch=${HPP_VERSION}
hpp-affordance-corba_repository=${HPP_REPO}
hpp-affordance-corba_extra_flags=${HPP_EXTRA_FLAGS}
hpp-affordance-corba_jobs=1

anymal-rbprm_branch=${HPP_VERSION}
anymal-rbprm_repository=${HPP_REPO}

hyq-rbprm_branch=${HPP_VERSION}
hyq-rbprm_repository=${HPP_REPO}

simple-humanoid-rbprm_branch=${HPP_VERSION}
simple-humanoid-rbprm_repository=${HPP_REPO}

solo-rbprm_branch=${HPP_VERSION}
solo-rbprm_repository=${HPP_REPO}

talos-rbprm_branch=${HPP_VERSION}
talos-rbprm_repository=${HPP_REPO}

hpp-rbprm_branch=${HPP_VERSION}
hpp-rbprm_repository=${HPP_REPO}
hpp-rbprm_extra_flags=${HPP_EXTRA_FLAGS}

hpp-rbprm-corba_branch=${HPP_VERSION}
hpp-rbprm-corba_repository=${HPP_REPO}
hpp-rbprm-corba_extra_flags=${HPP_EXTRA_FLAGS}

hpp-centroidal-dynamics_branch=${HPP_VERSION}
hpp-centroidal-dynamics_repository=${HPP_REPO}

hpp-bezier-com-traj_branch=${HPP_VERSION}
hpp-bezier-com-traj_repository=${HPP_REPO}
hpp-bezier-com-traj_extra_flags= -DBUILD_PYTHON_INTERFACE=ON

ndcurves_branch=devel
ndcurves_repository=${LOCO3D_REPO}
ndcurves_extra_flags= -DBUILD_PYTHON_INTERFACE=ON

# }}}
##################################
# {{{ Packages for gepetto-gui

gepetto-viewer_branch=${HPP_VERSION}
gepetto-viewer_repository=${GEPETTO_REPO}
gepetto-viewer_extra_flags= -DPROJECT_USE_QT4=OFF -DINSTALL_DOCUMENTATION=OFF

gepetto-viewer-corba_branch=${HPP_VERSION}
gepetto-viewer-corba_repository=${GEPETTO_REPO}
gepetto-viewer-corba_extra_flags= -DINSTALL_DOCUMENTATION=OFF

qgv_branch=devel
qgv_repository=${GEPETTO_REPO}

hpp-tools_branch=${HPP_VERSION}
hpp-tools_repository=${HPP_REPO}
hpp-tools_extra_flags=

# }}}
##################################
# {{{ High-level targets

all: hpp_tutorial.install hpp-gepetto-viewer.install hpp-plot.install hpp-gui.install hpp-python.install example-robot-data.install-py
	${MAKE} hpp-doc.install

# For test on gepgitlab, install robot packages first
# TODO: add hpp-affordance-corba.install back after next coal release
test-ci: example-robot-data.install  hpp-environments.install \
	hpp-baxter.install
	${MAKE} hpp_tutorial.install hpp-gepetto-viewer.install \
	hpp-universal-robot.install && \
	${MAKE} hpp-doc.install

# For benchmark, install robot packages first
benchmark: example-robot-data.install hpp-environments.install
	${MAKE} hpp_tutorial.install hpp-gepetto-viewer.install; \
	${MAKE} hpp-baxter.install hpp_romeo.install \
	hpp-universal-robot.install hpp-plot.install hpp-gui.install; \
	${MAKE} hpp_benchmark.checkout; \
	${MAKE} hpp-doc.install

rbprm: hpp-affordance-corba.install hpp-gepetto-viewer.install
	${MAKE} hpp-doc.install


# }}}
##################################
# {{{ Dependencies declaration

hpp-doc.configure.dep: hpp-doc.checkout \
	jrl-cmakemodules.install
jrl-cmakemodules.configure.dep: jrl-cmakemodules.checkout
eigenpy.configure.dep: eigenpy.checkout \
	jrl-cmakemodules.install
coal.configure.dep: coal.checkout
coal.configure-py.dep: coal.install \
	eigenpy.install
hpp-util.configure.dep: hpp-util.checkout \
	jrl-cmakemodules.install
pinocchio.configure.dep: pinocchio.checkout \
	coal.install example-robot-data.install
pinocchio.configure-py.dep: pinocchio.install \
	eigenpy.install coal.install-py
hpp-pinocchio.configure.dep: hpp-pinocchio.checkout \
	pinocchio.install hpp-util.install hpp-environments.install
hpp-statistics.configure.dep: hpp-statistics.checkout \
	hpp-util.install
hpp-core.configure.dep: hpp-core.checkout \
	example-robot-data.install proxsuite.install hpp-constraints.install hpp-statistics.install
hpp-constraints.configure.dep: hpp-constraints.checkout \
	hpp-pinocchio.install hpp-statistics.install hpp-environments.install
hpp-manipulation.configure.dep: hpp-manipulation.checkout \
	hpp-core.install hpp-constraints.install
hpp-manipulation-corba.configure.dep: hpp-manipulation-corba.checkout \
	hpp-manipulation-urdf.install hpp-manipulation.install hpp-corbaserver.install hpp-template-corba.install
hpp-plot.configure.dep: hpp-plot.checkout \
	hpp-corbaserver.install hpp-manipulation-corba.install qgv.install
hpp-manipulation-urdf.configure.dep: hpp-manipulation-urdf.checkout \
	hpp-manipulation.install
hpp-corbaserver.configure.dep: hpp-corbaserver.checkout \
	hpp-core.install hpp-template-corba.install hpp-constraints.install
hpp-python.configure.dep: hpp-python.checkout \
	eigenpy.install hpp-corbaserver.install hpp-manipulation.install hpp-manipulation-urdf.install
hpp-template-corba.configure.dep: hpp-template-corba.checkout \
	hpp-util.install
qgv.configure.dep: qgv.checkout \
	jrl-cmakemodules.install
robot_model_py.configure.dep: robot_model_py.checkout
robot_capsule_urdf.configure.dep: robot_capsule_urdf.checkout \
	robot_model_py.install
hpp_tutorial.configure.dep: hpp_tutorial.checkout \
	hpp-gepetto-viewer.install hpp-python.install hpp-manipulation-corba.install
hpp-practicals.configure.dep: hpp-practicals.checkout \
	jrl-cmakemodules.install
hpp_benchmark.configure.dep: hpp_benchmark.checkout \
	hpp_tutorial.install
gepetto-viewer.configure.dep: gepetto-viewer.checkout \
	qgv.install
gepetto-viewer-corba.configure.dep: gepetto-viewer-corba.checkout \
	gepetto-viewer.install
hpp-gepetto-viewer.configure.dep: hpp-gepetto-viewer.checkout \
	hpp-corbaserver.install gepetto-viewer-corba.install
hpp-gui.configure.dep: hpp-gui.checkout \
	gepetto-viewer-corba.install hpp-corbaserver.install hpp-manipulation-corba.install coal.install
universal_robot.configure.dep: universal_robot.checkout
hpp-universal-robot.configure.dep: hpp-universal-robot.checkout \
	example-robot-data.install
proxsuite.configure.dep: proxsuite.checkout \
	jrl-cmakemodules.install
example-robot-data.configure.dep: example-robot-data.checkout \
	jrl-cmakemodules.install
example-robot-data.configure-py.dep: example-robot-data.install \
	pinocchio.install-py
hpp-environments.configure.dep: hpp-environments.checkout \
	example-robot-data.install
hpp-baxter.configure.dep: hpp-baxter.checkout \
	example-robot-data.install
hpp_romeo.configure.dep: hpp_romeo.checkout \
	jrl-cmakemodules.install
hpp-affordance.configure.dep: hpp-affordance.checkout \
	hpp-core.install coal.install
hpp-affordance-corba.configure.dep: hpp-affordance-corba.checkout  \
	hpp-affordance.install hpp-template-corba.install hpp-corbaserver.install
anymal-rbprm.configure.dep: anymal-rbprm.checkout \
	jrl-cmakemodules.install
hyq-rbprm.configure.dep: hyq-rbprm.checkout \
	jrl-cmakemodules.install
simple-humanoid-rbprm.configure.dep: simple-humanoid-rbprm.checkout \
	jrl-cmakemodules.install
solo-rbprm.configure.dep: solo-rbprm.checkout \
	jrl-cmakemodules.install
talos-rbprm.configure.dep: talos-rbprm.checkout \
	jrl-cmakemodules.install
hpp-rbprm.configure.dep: hpp-rbprm.checkout \
	hpp-core.install hpp-centroidal-dynamics.install anymal-rbprm.install \
	hyq-rbprm.install talos-rbprm.install simple-humanoid-rbprm.install \
	solo-rbprm.install hpp-affordance.install ndcurves.install hpp-bezier-com-traj.install
hpp-rbprm-corba.configure.dep: hpp-rbprm-corba.checkout \
	hpp-rbprm.install hpp-affordance-corba.install hpp-corbaserver.install
hpp-centroidal-dynamics.configure.dep: hpp-centroidal-dynamics.checkout \
	jrl-cmakemodules.install
hpp-bezier-com-traj.configure.dep: hpp-bezier-com-traj.checkout \
	hpp-centroidal-dynamics.install ndcurves.install
ndcurves.configure.dep: ndcurves.checkout \
	jrl-cmakemodules.install
hpp-tools.configure.dep: hpp-tools.checkout \
	jrl-cmakemodules.install

# }}}
##################################
# {{{ Targets

status:
	@for child_dir in $$(ls ${SRC_DIR}); do \
		test -d "$$child_dir" || continue; \
		test -d "$$child_dir/.git" || continue; \
		${MAKE} "$$child_dir".status; \
	done

log:
	@for child_dir in $$(ls ${SRC_DIR}); do \
		test -d "$$child_dir" || continue; \
		test -d "$$child_dir/.git" || continue; \
		${MAKE} "$$child_dir".log; \
	done

fetch:
	@for child_dir in $$(ls ${SRC_DIR}); do \
		test -d "$$child_dir" || continue; \
		test -d "$$child_dir/.git" || continue; \
		${MAKE} "$$child_dir".fetch; \
	done

update:
	@for child_dir in $$(ls ${SRC_DIR}); do \
		test -d "$$child_dir" || continue; \
		test -d "$$child_dir/.git" || continue; \
		${MAKE} "$$child_dir".update; \
	done

test:
	@for child_dir in $$(ls ${SRC_DIR}); do \
		test -d "$$child_dir" || continue; \
		test -d "$$child_dir/.git" || continue; \
		${MAKE} "$$child_dir".test; \
	done

%.checkout:
	if [ -d $(@:.checkout=)/.git ]; then \
		echo "$(@:.checkout=) already checkout out."; \
	else \
		git clone ${GIT_QUIET} -b ${$(@:.checkout=)_branch} ${$(@:.checkout=)_repository}/$(@:.checkout=); \
	fi \

%.fetch:
	if [ "${$(@:.fetch=)_repository}" = "" ]; then \
		echo "$(@:.fetch=) is not referenced"; \
	else \
		cd ${SRC_DIR}/$(@:.fetch=);\
		git fetch ${GIT_QUIET} origin; \
		git fetch ${GIT_QUIET} origin --tags; \
	fi

%.update:
	if [ "${$(@:.update=)_repository}" = "" ]; then \
		echo "$(@:.update=) is not referenced"; \
	else \
		cd ${SRC_DIR}/$(@:.update=);\
		git remote rm origin;\
		git remote add origin ${$(@:.update=)_repository}/$(@:.update=);\
		git fetch origin;\
		git fetch origin --tags;\
		git checkout -q --detach;\
		git branch -f ${$(@:.update=)_branch} origin/${$(@:.update=)_branch};\
		git checkout -q ${$(@:.update=)_branch};
	fi


%.configure: %.configure.dep
	${MAKE} $(@:.configure=).configure_nodep

%.configure-py: %.configure-py.dep
	${MAKE} $(@:.configure-py=).configure_nodep-py

%.configure_nodep:%.checkout
	cmake \
		-DAUTO_UNINSTALL=OFF \
		-DBUILD_PYTHON_INTERFACE=OFF \
		-DCMAKE_INSTALL_PREFIX=${INSTALL_HPP_DIR} \
		-DCMAKE_INSTALL_LIBDIR=lib \
		-DCMAKE_BUILD_TYPE=${BUILD_TYPE} \
		-DENFORCE_MINIMAL_CXX_STANDARD=ON \
		-DINSTALL_DOCUMENTATION=${INSTALL_DOCUMENTATION} \
		-DCMAKE_CXX_FLAGS_RELWITHDEBINFO="-g -O3 -DNDEBUG" \
		${$(@:.configure_nodep=)_extra_flags} \
		-B ${SRC_DIR}/$(@:.configure_nodep=)/${BUILD_FOLDER} \
		-S ${SRC_DIR}/$(@:.configure_nodep=)

%.configure_nodep-py:%.checkout
	cmake \
		-DAUTO_UNINSTALL=OFF \
		-DBUILD_PYTHON_INTERFACE=ON \
		-DBUILD_STANDALONE_PYTHON_INTERFACE=ON \
		-DCMAKE_INSTALL_PREFIX=${INSTALL_HPP_DIR} \
		-DCMAKE_INSTALL_LIBDIR=lib \
		-DCMAKE_BUILD_TYPE=${BUILD_TYPE} \
		-DENFORCE_MINIMAL_CXX_STANDARD=ON \
		-DINSTALL_DOCUMENTATION=${INSTALL_DOCUMENTATION} \
		-DCMAKE_CXX_FLAGS_RELWITHDEBINFO="-g -O3 -DNDEBUG" \
		${$(@:.configure_nodep-py=)_extra_flags} \
		-B ${SRC_DIR}/$(@:.configure_nodep-py=)/${BUILD_FOLDER}-py \
		-S ${SRC_DIR}/$(@:.configure_nodep-py=)


%.build:%.configure
	cmake --build ${SRC_DIR}/$(@:.build=)/${BUILD_FOLDER} -j $(or $($(@:.build=)_jobs),${BUILD_JOBS})

%.build-py:%.configure-py
	cmake --build ${SRC_DIR}/$(@:.build-py=)/${BUILD_FOLDER}-py -j $(or $($(@:.build-py=)_jobs),${BUILD_JOBS})

%.test:%.build
	cmake --build ${SRC_DIR}/$(@:.test=)/${BUILD_FOLDER} -t test

%.test-py:%.build-py
	cmake --build ${SRC_DIR}/$(@:.test-py=)/${BUILD_FOLDER}-py -t test

%.install:%.build
	cmake --build ${SRC_DIR}/$(@:.install=)/${BUILD_FOLDER} -t install

%.install-py:%.build-py
	cmake --build ${SRC_DIR}/$(@:.install-py=)/${BUILD_FOLDER}-py -t install

%.install_nodep:%.configure_nodep
	cmake --build ${SRC_DIR}/$(@:.install_nodep=)/${BUILD_FOLDER} -t install

%.install_nodep-py:%.configure_nodep-py
	cmake --build ${SRC_DIR}/$(@:.install_nodep-py=)/${BUILD_FOLDER}-py -t install

%.uninstall:
	cmake --build ${SRC_DIR}/$(@:.uninstall=)/${BUILD_FOLDER} -t uninstall

%.uninstall-py:
	cmake --build ${SRC_DIR}/$(@:.uninstall-py=)/${BUILD_FOLDER}-py -t uninstall

%.clean:
	cmake --build ${SRC_DIR}/$(@:.clean=)/${BUILD_FOLDER} -t clean

%.clean-py:
	cmake --build ${SRC_DIR}/$(@:.clean-py=)/${BUILD_FOLDER}-py -t clean

%.very-clean:
	rm -rf ${SRC_DIR}/$(@:.very-clean=)/${BUILD_FOLDER}/*

%.very-clean-py:
	rm -rf ${SRC_DIR}/$(@:.very-clean-py=)/${BUILD_FOLDER}-py/*

%.status:
	@cd ${SRC_DIR}/$(@:.status=); \
	echo \
	"\033[1;36m------- Folder $(@:.status=) ---------------\033[0m"; \
	git --no-pager -c status.showUntrackedFiles=no status --short --branch;\

%.log:
	@cd ${SRC_DIR}/$(@:.log=); \
	if [ -f .git/refs/heads/${$(@:.log=)_branch} ]; then \
		echo -n "$(@:.log=): "; \
		cat .git/refs/heads/${$(@:.log=)_branch}; \
	fi


# }}}

# vim: foldmethod=marker foldlevel=0
