// Copyright (c) 2008-2014, Andrew Walker
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
#ifndef DUBINS_H
#define DUBINS_H

// Path types
#define LSL (0)
#define LSR (1)
#define RSL (2)
#define RSR (3)
#define RLR (4)
#define LRL (5)

// The three segment types a path can be made up of
#define L_SEG (0)
#define S_SEG (1)
#define R_SEG (2)

// Error codes
#define EDUBOK (0)         // No error
#define EDUBCOCONFIGS (1)  // Colocated configurations
#define EDUBPARAM (2)      // Path parameterisitation error
#define EDUBBADRHO (3)     // the rho value is invalid
#define EDUBNOPATH (4)  // no connection between configurations with this word

// The segment types for each of the Path types
const int DIRDATA[][3] = {{L_SEG, S_SEG, L_SEG}, {L_SEG, S_SEG, R_SEG},
                          {R_SEG, S_SEG, L_SEG}, {R_SEG, S_SEG, R_SEG},
                          {R_SEG, L_SEG, R_SEG}, {L_SEG, R_SEG, L_SEG}};

#define UNPACK_INPUTS(alpha, beta) \
  double sa = sin(alpha);          \
  double sb = sin(beta);           \
  double ca = cos(alpha);          \
  double cb = cos(beta);           \
  double c_ab = cos(alpha - beta);

#define PACK_OUTPUTS(outputs) \
  outputs[0] = t;             \
  outputs[1] = p;             \
  outputs[2] = q;

// The various types of solvers for each of the path types
typedef int (*DubinsWord)(double, double, double, double*);

// A complete list of the possible solvers that could give optimal paths
extern DubinsWord dubins_words[];
int dubins_LSL(double alpha, double beta, double d, double* outputs);
int dubins_RSR(double alpha, double beta, double d, double* outputs);
int dubins_LSR(double alpha, double beta, double d, double* outputs);
int dubins_RSL(double alpha, double beta, double d, double* outputs);
int dubins_LRL(double alpha, double beta, double d, double* outputs);
int dubins_RLR(double alpha, double beta, double d, double* outputs);

#endif  // DUBINS_H
